********************************************************************************
****************************** Exercise 1 **************************************
******************************* Solution ***************************************



***************************** Question 1: **************************************
* Import and Save NumUnit .txt file to a .dta file
import delimited "My file path:\...\NumUnit.txt"

save "My file path:\...\NumUnit.dta"

* Clear
clear




***************************** Question 2: **************************************
* Import the first sheet labelled 'Weight'
import excel "My file path:\...\Chapter 6 Practical Dataset.xlsx", sheet("Weight") firstrow

* Merge with NumUnit stata file
merge m:1 numunitid using "My file path:\...\NumUnit.dta"

* Keep matched (Should be 12)
keep if _merge==3

browse

* Drop unnecessary variables
drop _merge




***************************** Question 3: **************************************
* Generate metricweight variable for those with kg unit
gen metricweight=Weight if description=="kg"

* Conversion for lbs unit
replace metricweight = (Weight/2.205) if description=="Lbs"

* Look at the value, it looks like it relates to stones. Therefore we use conversion for stones
replace metricweight = (Weight*6.35) if description == "Weight (stones/pounds)"




***************************** Question 4: **************************************
* Mean with confidence intervals
ci means metricweight

* Mean with min and max values
summ metricweight




***************************** Question 5:
* Drop unnecessary variable
drop numunitid

* Save
save "My file path:\...\Metric_Weight.dta"

* Clear
clear




***************************** Question 6:
* Import Height excel sheet
import excel "My file path:\...\Chapter 6 Practical Dataset.xlsx", sheet("Height") firstrow

* Merge with NumUnit stata file
merge m:1 numunitid using "My file path:\...\NumUnit.dta"

* Keep those matched (Should be 12)
keep if _merge==3
browse

* Drop unnecessary variable
drop _merge




***************************** Question 7:
* Generate metricheight variable for those with m unit
gen metricheight = Height if description=="m"

* Conversion for meter squared variable
replace metricheight = (sqrt(Height)) if description=="m2"

* inches = 39.37 x meters from google search
replace metricheight = (Height/39.37) if description=="inches"




***************************** Question 8:
* Yes, unit "C" does not refer to height.
replace metricheight = . if description=="C"




***************************** Question 9:
* Mean with confidence intervals
ci means metricheight

* Mean with min and max values
summ metricheight




***************************** Question 10:
* Rename description so it is not confused with description variable in Weight stata dataset
rename description description_height

* Drop unnecessary variable
drop numunitid

* Merge with Weight dataset
merge 1:1 patid using "My file path:\...\Metric_Weight.dta"

* Keep those matched (Should be 12)
keep if _merge==3

* Drop unnecessary variable
drop _merge




***************************** Question 11:
* Generate BMI with equation given (equation taken from NHS website)
gen BMI = metricweight/(metricheight)^2




***************************** Question 12:
* Mean for BMI
summ BMI